package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.web.model.MyGoalTask;

@Component
public class MyGoalTaskDTOConverter implements Converter<MyGoalTask, MyGoalTaskDTO>, Serializable {
	private static final long serialVersionUID = 1L;

	@Override
	public MyGoalTaskDTO convert(MyGoalTask model) {
		MyGoalTaskDTO dto = new MyGoalTaskDTO();
		
		dto.setCompletedDate(model.getCompletedDate());
		dto.setCompletionType(model.getCompletionType());
		dto.setDescription(model.getDescription());
		dto.setEndDate(model.getEndDate());
		dto.setEndTime(model.getEndTime());
		dto.setGoalExtensionId(model.getGoalExtensionId());
		dto.setTaskId(model.getTaskId());
		dto.setStartDate(model.getStartDate());
		dto.setStartTime(model.getStartTime());
		if (model.getStatus() != null) {
			dto.setStatus(model.getStatus());
		}
		else {
			dto.setStatus(0);
		}
		dto.setTaskName(model.getTaskName());
		dto.setTaskRepetitionCycleType(model.getTaskRepetitionCycleType());
		dto.setTaskSequenceNumber(model.getTaskSequenceNumber());
		dto.setOplock(model.getOplock());
		
		return dto;
	}
}
